/**
 * JavaScript for Design Instruct's Make a Stylishly Elegant Portfolio Web Design in Photoshop tutorial
 *
 * http://designinstruct.com/web-design/make-a-stylishly-elegant-portfolio-web-design-in-photoshop/
 *
 * LICENSE: This source file is subject to Creative Commons Attribution-ShareAlike 3.0 Unported License
 * Use the following code for proper attribution:
 <a rel="license" href="http://creativecommons.org/licenses/by-sa/3.0/"><img alt="Creative Commons License" style="border-width:0" src="http://i.creativecommons.org/l/by-sa/3.0/88x31.png" /></a><br /><span xmlns:dc="http://purl.org/dc/elements/1.1/" href="http://purl.org/dc/dcmitype/InteractiveResource" property="dc:title" rel="dc:type">Make a Stylishly Elegant Portfolio Web Design in Photoshop</span> by <a xmlns:cc="http://creativecommons.org/ns#" href="http://designinstruct.com/web-design/make-a-stylishly-elegant-portfolio-web-design-in-photoshop/" property="cc:attributionName" rel="cc:attributionURL">Design Instruct</a> is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/3.0/">Creative Commons Attribution-ShareAlike 3.0 Unported License</a>.<br />Based on a work at <a xmlns:dc="http://purl.org/dc/elements/1.1/" href="http://designinstruct.com/web-design/make-a-stylishly-elegant-portfolio-web-design-in-photoshop/" rel="dc:source">designinstruct.com</a>.<br />Permissions beyond the scope of this license may be available at <a xmlns:cc="http://creativecommons.org/ns#" href="http://designinstruct.com/web-design/make-a-stylishly-elegant-portfolio-web-design-in-photoshop/" rel="cc:morePermissions">http://designinstruct.com/web-design/make-a-stylishly-elegant-portfolio-web-design-in-photoshop/</a>.
 *
 * @author     Jacob Gube <jacob@sixrevisions.com>
 * @author     Sebastiano Guerriero
 * @copyright  Design Instruct
 * @license    http://creativecommons.org/licenses/by-sa/3.0/  Creative Commons Attribution-ShareAlike 3.0 Unported License
 * @link       http://designinstruct.com/web-design/make-a-stylishly-elegant-portfolio-web-design-in-photoshop/
 */

$(document).ready(function(){
    /*Contact Us web form in footer */
	$('#usr-msg')
	.focus(function(){ $(this).val(''); })
	.blur(function(){ if($(this).val()=='') { $(this).val('Your Message Here...') } });
	/* Slideshow */
	// Static
	var slideshowWidth = $('.slideshow').width();
	var slideshowHeight = $('.slideshow').height();
	var numSlides = $('.slide').size();
	var slidePosition = 0;
	var controlsHeight = 70;
	var slideDuration = 500;
	// User agent has JS enabled, undo CSS degradation stuff
		// Make space for controls at the bottom
	$('.slideshow').css({'height': slideshowHeight+controlsHeight, 'overflow':'hidden'});
	$('.slide').css({'width':slideshowWidth, 'height': slideshowHeight, 'float': 'left'});
	// Wrap all slides in a div
	$('.slide').wrapAll('<div class="slidesWrapper" />');
	// DOM insert control container rather than hard-code in markup
	$('.slidesWrapper')
	.after('<div class="controls" />')
	.css({'height': slideshowHeight, 'overflow':'hidden', 'float':'left'});
	// DOM insert left/right controls rather than hard-code in markup
	$('.controls')
	.css({'height':controlsHeight, 'clear':'both'})
	.html('<ul><li class="left-slide">Left</li><li class="right-slide">Right</li></ul>');
	// Handles movement logic
	$('.controls ul li').click(function(){					
		if($(this).hasClass('left')) {
			if(slidePosition!=0){
				slidePosition = slidePosition-1;
				moveSlide(slidePosition,slideshowWidth);
			}
			else {
				slidePosition = numSlides-1;
				moveSlide(slidePosition,slideshowWidth);
			}
		}
		else {
			if(slidePosition!=(numSlides-1)) {
				slidePosition = slidePosition+1;
				moveSlide(slidePosition,slideshowWidth);
			}
			else {
				slidePosition = 0;
				moveSlide(slidePosition,slideshowWidth);
			}
		}
});
// Moves slides
function moveSlide(x,y) {
	$('.slidesWrapper').animate({'marginLeft': -(x*y)}, slideDuration);
}
});